<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
xmlns="http://www.w3.org/1999/xhtml">

<xsl:output
	method="html"
	encoding="UTF-16"
	doctype-public="-//W3C//DTD XHTML 1.1//EN"
	doctype-system="http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd"
	indent="yes"
	cdata-section-elements="style script"/>

<xsl:template match="/root">
	<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<meta http-equiv="content-type" content="text/html; charset=utf-16" />
		<link rel="stylesheet" href="../css/default.css" media="all" charset="utf-8" type="text/css"></link>
		<link rel="stylesheet" href="../css/tag_cloud_detail.css" media="all" charset="utf-8" type="text/css"></link>
		<link rel="stylesheet" href="../css/print.css" media="print" charset="utf-8" type="text/css"></link>
		<link rel="stylesheet" href="../css/tablesortCommon.css" media="screen,print" charset="utf-8" type="text/css"></link>
		<link rel="stylesheet" href="../css/zero_states.css" media="all" charset="utf-8" type="text/css"></link>

<!-- Inline Styles -->
		<style type="text/css">
.financial td.dateHeader, td.checkNumberHeader { width: 60pt; }
.financial td.debitHeader, td.creditHeader, td.balanceHeader { width: 80pt; }
		</style>
		
		<script type="text/javascript" src="../js/jquery.js" charset="utf-8"></script>
		<script type="text/javascript" src="../js/jquery.metadata.js" charset="utf-8"></script>
		<script type="text/javascript" src="../js/jquery.tablesorter.js" charset="utf-8"></script>
		<script type="text/javascript" src="../js/tablesorterParsers.js" charset="utf-8"></script>
		<script type="text/javascript" src="../js/quickzoomTx.js" charset="utf-8"></script>
		<script type="text/javascript" src="../js/transactionDetail.js" charset="utf-8"></script>
        <script type="text/javascript" src="../js/utils.js" charset="utf-8"></script>

		<script type="text/javascript">
			function TransactionDetailInit() {
				MultiTableSortInit("table.transactionDetail");
			}
			$(TransactionDetailInit);
			<!-- $(UserTagsInit); -->
			$(QuickZoomTransactionsInit);
		</script>
	</head>

	<body id="tagCloudDeatil">
		<div id="outerWrapper">

			<!-- Do we have any data? -->
			<xsl:choose>
				<xsl:when test="count(currency)>0">
				<!-- Begin: innerWrapper - WITH data -->
					<div id="innerWrapper" class="fullWidth clearAfter">
							<xsl:apply-templates select="currency"/>
					</div><!-- End: innerWrapper -->
				</xsl:when>	
				
				<xsl:otherwise>
					<!-- Begin: innerWrapper - NO data -->
					<div id="innerWrapperZeroDataCategory" class="fullWidth clearAfter">
						<div class="zeroState">
							<div class="noDataA">
								<p class="first">No Transactions for this Month.</p>
							</div>	
						</div>
					</div><!-- End: innerWrapper -->
				</xsl:otherwise>	
			</xsl:choose>

		</div><!-- END outerWrapper -->
	</body>
	</html>

</xsl:template>

<xsl:template match="currency">
	<xsl:apply-templates select="accountClass"/>
</xsl:template>

<xsl:template match="accountClass">
	<xsl:apply-templates select="account"/>
</xsl:template>

<xsl:template match="account">
	<xsl:if test="count(../../../currency) > 1">
		<div class="currencyID"><xsl:value-of select="../../@currencyID"/></div>
	</xsl:if>

	<div class="accountNameHeader" id="accountHeader_{title}"><xsl:value-of select="title"/></div>

	<xsl:apply-templates select="transactionType"/>
</xsl:template>


<xsl:template match="transactionType">

	<div class="tableHeaderMonth" id="tableHeader_{title}"><xsl:value-of select="title"/></div>
    <div class="tableHeaderAmount" id="tableHeaderAmount_{title}">
        <xsl:choose>
            <xsl:when test="amount[@sign='negative']">
                <td colspan="6" class="subTotal negative"><xsl:value-of select="amount"/></td>
            </xsl:when>
            <xsl:otherwise>
                <td colspan="6" class="subTotal"><xsl:value-of select="amount"/></td>
            </xsl:otherwise>
        </xsl:choose>
    </div>
	<table class="transactionDetail">
		<thead><tr>
			<th class='dateHeader {{sorter: "{/root/dateSort}"}}'>Date</th>
			<th class='checkNumberHeader'>Check #</th>
			<th class='payeeHeaderMonth'>Payee</th>
			<th class='categoryHeaderMonth'>Category</th>
			<th class='tagsHeaderMonth'>Tags</th>
			<th class='amountHeader currency {{sorter: "qCurrency"}}'>Amount</th>
		</tr></thead>
		
		<tbody>
			<xsl:apply-templates select="transaction"/>
		</tbody>
	</table><div style="clear:both;"></div>
</xsl:template>

<xsl:template match="transaction">
	<tr id="transaction_{@quickenID}" class="{@ClassType}" quickenid="{@quickenID}" rawdate="{rawDate}">
		<td class="date" id="transDate_{@quickenID}"><xsl:value-of select="date"/></td>
        <td class="checkNumber" id="transCheck_{@quickenID}"><xsl:value-of select="checkNumber"/></td>
		<td class="payeeMonth" id="transPayee_{@quickenID}"><xsl:value-of select="payee"/></td>
		<td class="tagsMonth" id="transCategory_{@quickenID}">
			<ul class="userTags">
				<li><xsl:value-of select="categoryTag"/></li>
			</ul>
		</td>
		<td class="tagsMonth" id="transTags_{@quickenID}">
			<ul class="userTags">
				<li><xsl:value-of select="userTag"/></li>
			</ul>
		</td>
		<xsl:choose>
			<xsl:when test="count(subamount)">
				<xsl:apply-templates select="subamount"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates select="amount"/>
			</xsl:otherwise>
		</xsl:choose>
	</tr>
</xsl:template>

<xsl:template match="amount">
	<xsl:choose>
		<xsl:when  test="@sign='negative'">
			<td class="amount negative" id="transAmount_{../@quickenID}"><xsl:value-of select="."/></td>
		</xsl:when>
		<xsl:otherwise>
			<td class="amount" id="transAmount_{../@quickenID}"><xsl:value-of select="."/></td>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template match="subamount">
	<xsl:choose>
		<xsl:when  test="@sign='negative'">
			<td class="subamount negative" id="transAmount_{../@quickenID}"><xsl:value-of select="."/></td>
		</xsl:when>
		<xsl:otherwise>
			<td class="subamount" id="transAmount_{../@quickenID}"><xsl:value-of select="."/></td>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template match="dateSort" />

</xsl:stylesheet>
